﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista ward location entity.
    /// </summary>
    [Serializable]
    public class WardLocation : IEntity
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public String Name { get; set; }

        /// <summary>
        /// Gets or sets the name of the specialty.
        /// </summary>
        /// <value>
        /// The name of the specialty.
        /// </value>
        public String SpecialtyName { get; set; }

        /// <summary>
        /// Gets or sets the hospital location id (IEN).
        /// </summary>
        /// <value>
        /// The hospital location id.
        /// </value>
        public string HospitalLocationId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is currently out of service.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is currently out of service; otherwise, <c>false</c>.
        /// </value>
        public bool IsCurrentlyOutOfService { get; set; }

        /// <summary>
        /// Gets or sets the specialty id.
        /// </summary>
        /// <value>
        /// The specialty id.
        /// </value>
        public int? SpecialtyId { get; set; }


        public override string ToString()
        {
            return "WardLocation:" + Name;
        }

    }
}
